﻿namespace Hims.Api.Controllers
{
    using System;
    using System.Threading.Tasks;
    using Domain.Helpers;
    using Domain.Services;
    using Microsoft.AspNetCore.Mvc;
    using Shared.DataFilters;
    using Shared.UserModels;
    using Utilities;

    // ReSharper disable StyleCop.SA1126

    /// <inheritdoc />
    /// <summary>
    /// The account controller.
    /// </summary>
    [Route("api/timeline")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class TimelineController : BaseController
    {
        /// <summary>
        /// The account services.
        /// </summary>
        private readonly ITimelineService service;

        /// <summary>
        /// The AES helper.
        /// </summary>
        private readonly IAESHelper aesHelper;

        /// <inheritdoc />
        public TimelineController(IAESHelper aesHelper, ITimelineService service)
        {
            this.service = service;
            this.aesHelper = aesHelper;
        }

        /// <summary>
        /// The update agreement status async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [Route("fetch")]
        public async Task<ActionResult> FetchAsync([FromBody] TimelineRequestModel model)
        {
            model = (TimelineRequestModel)EmptyFilter.Handler(model);
            model.AppointmentId = Convert.ToInt32(this.aesHelper.Decode(model.AppointmentEid));
            var records = await this.service.FetchAsync(model);
            return this.Success(records);
        }

        /// <summary>
        /// The update agreement status async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [Route("view")]
        [HttpPost]
        public async Task<ActionResult> FetchViewAsync([FromBody] IdRequestModel model)
        {
            model = (IdRequestModel)EmptyFilter.Handler(model);
            var records = await this.service.FetchViewAsync(Convert.ToInt32(model.Id));
            return this.Success(records);
        }
    }
}